<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslResourceDirectory" select="cif:xslResourceDirectory"/>
    <!-- Horizontal Element Tabling -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslResourceDirectory}/engtheme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Horizontal Element Tabling</title>
            </head>
            <body>
        <xsl:for-each select="InRoads">
            <xsl:for-each select="GeometryProject">
                         <xsl:for-each select="HorizontalAlignment">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Horizontal Element Tabling</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <table class="margin">
                                <tr>
                                    <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                    <td align="left" style="font-size: 80%"><xsl:value-of select="../@inputGridScaleFactor"/></td>
                                    <td class="sidepad" align="right" lang="en" style="font-size: 80%">
                                        <strong>Note:&#xa0; </strong>All units in this report are in
                                        <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                        <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                        unless specified otherwise.
                                    </td>
                                </tr>
                            </table>
                            <hr/>
                            <!-- Horizontal Line Table -->
                            <table class="margin" border="1" cellpadding="2" cellspacing="0">
                                <thead style="display:table-header-group">
                                    <tr><th colspan="3" lang="en">LINE TABLE</th></tr>
                                    <tr>
                                        <th lang="en" valign="bottom">LINE NO.</th>
                                        <th lang="en" valign="bottom">BEARING</th>
                                        <th lang="en" valign="bottom">DISTANCE</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="HorizontalLine">
                                        <tr>
                                            <td><xsl:value-of select="../@name"/></td>
					    <td class="sidepad" align="right" nowrap="nowrap">
                                                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                                            </td>
                                            
                                        </tr>
                                    </xsl:for-each>
                                </tbody>
                            </table>
                            <br/>
                            <!-- Horizontal Circle Table -->
                            <table class="margin" border="1" cellpadding="2" cellspacing="0">
                                <thead style="display:table-header-group">
                                    <tr><th colspan="9" lang="en">CURVE TABLE</th></tr>
                                    <tr>
                                        <th lang="en" valign="bottom">CURVE NO.</th>
                                        <th lang="en" valign="bottom">PI STATION</th>
                                        <th lang="en" valign="bottom">PI NORTHING</th>
                                        <th lang="en" valign="bottom">PI EASTING</th>
                                        <th lang="en" valign="bottom">DELTA</th>
                                        <th lang="en" valign="bottom">Tc</th>
                                        <th lang="en" valign="bottom">Rc</th>
                                        <th lang="en" valign="bottom">Dc</th>
                                        <th lang="en" valign="bottom">MDS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="TableCircle/HorizontalCircle">
                                        <tr>
                                            <td><xsl:value-of select="../@name"/></td>

					    <td class="sidepad" align="right">
                				<xsl:value-of select="cif:stationFormat(number(PI/station/@internalStation), string(Start/station/@externalStationName))"/>
           				    </td>
            				    <td align="right">
                                                <xsl:value-of select="cif:ordinateFormat(number(PI/@northing))"/>
                                            </td>
                                            <td align="right">
                                                <xsl:value-of select="cif:eastingFormat(number(PI/@easting))"/>
                                            </td>

					    <td class="sidepad" align="right">
					    <xsl:value-of select="cif:angularFormat(number(@delta))"/>
                                            <xsl:if test="@rotationDirection='cw'"> RT</xsl:if>
                                            <xsl:if test="@rotationDirection = 'ccw'"> LT</xsl:if>
           				    </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:angularFormat(number(@degreeOfCurve))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                 MPH
                                            </td>

                                        </tr>
                                    </xsl:for-each>
                                </tbody>
                            </table>
                            <br/>
                            <!-- Horizontal Spiral Table -->
                            <table class="margin" border="1" cellpadding="2" cellspacing="0">
                                <thead style="display:table-header-group">
                                    <tr>
                                        <th colspan="6" lang="en">SPIRAL TABLE</th>
                                    </tr>
                                    <tr>
                                        <th lang="en" valign="bottom">Name</th>
                                        <th lang="en" valign="bottom">Spiral PI</th>
                                        <th lang="en" valign="bottom">Spiral Theta</th>
                                        <th lang="en" valign="bottom">Spiral Length</th>
                                        <th lang="en" valign="bottom">LT</th>
                                        <th lang="en" valign="bottom">ST</th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <xsl:for-each select="TableSpiral/HorizontalSpiral">
                                        <tr>
                                            <td><xsl:value-of select="../@name"/></td>
					    <td class="sidepad" align="right">
                				<xsl:value-of select="cif:stationFormat(number(PI/station/@internalStation), string(Start/station/@externalStationName))"/>
           				    </td>

                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:angularFormat(number(@thetaAngle))"/>
                                                <xsl:if test="@rotationDirection='cw'"> RT</xsl:if>
                                                <xsl:if test="@rotationDirection = 'ccw'"> LT</xsl:if>
                                            </td>
                                           <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:distanceFormat(number(@longTangent))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:distanceFormat(number(@shortTangent))"/>
                                            </td>

                                        </tr>

                                    </xsl:for-each>
                                </tbody>
                            </table>
                            <br/>
                            <!-- Point Table -->
                            <table class="margin" border="1" cellpadding="2" cellspacing="0">
                                <thead style="display:table-header-group">
                                    <tr>
                                        <th colspan="6" lang="en">Point Table</th>
                                    </tr>
                                    <tr>
                                        <th lang="en">Name</th>
                                        <th lang="en">Northing</th>
                                        <th lang="en">Easting</th>
                                        <th lang="en">Elevation</th>
                                        <th lang="en">Description</th>
                                        <th lang="en">Style</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="TablePoint/GeometryPoint">
                                        <tr>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="../@name &gt; 0">
                                                        <xsl:value-of select="../@name"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>&#xa0;</xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:eastingFormat(number(@easting))"/>
                                            </td>
                                            <td class="sidepad" align="right">
                                                <xsl:value-of select="cif:elevationFormat(number(@elevation))"/>
                                            </td>
                                            <td>
                                                <xsl:choose>
                                                    <xsl:when test="@description">
                                                        <xsl:value-of select="@description"/>
                                                    </xsl:when>
                                                    <xsl:otherwise>&#xa0;</xsl:otherwise>
                                                </xsl:choose>
                                            </td>
                                            <td><xsl:value-of select="@style"/></td>
                                        </tr>
                                    </xsl:for-each>
                                </tbody>
                            </table>
                            <br/>
                        </xsl:for-each>
                        </xsl:for-each>
                        </xsl:for-each>
            </body>
        </html>
    </xsl:template>
 
</xsl:stylesheet>
